#ifndef _DEFINES_H_
#define _DEFINES_H_

/**
* ISO/IEC 14443-3 and 14443-4 related defines
* Also NFCForum-TS-DigitalProtocol
*/
#define TYPEA_SAK_LEN               0x01
#define TYPEA_ATQA_LEN              0x02

#define TYPEA_SLP_REQ_BYTE_1            0x50 /* ISO 6.3.3 HLTA Command, lenght 2byte 50h 00h */
#define TYPEA_SLP_REQ_BYTE_2            0x00
#define TYPEA_SLP_REQ_LENGTH            0x02 /* Length of HTLA command SHALL be 2 */

#define TYPEB_SLP_REQ_BYTE_1            0x50 /* Digital 5.8.1 SLPB_REQ Command */
#define TYPEB_SLP_REQ_LENGTH            0x05
#define TYPEB_SLP_RES                   0x00 /* Digital 5.8.2 SLPB_RES Response */

#define ISO_PPS_MIN_LENGTH              0x02 /* The PPS Req is at minimum 2 bytes long (PPS + PPS0) */
#define ISO_PPS_MAX_LENGTH              0x03 /* The PPS Req is at maximum 3 bytes long (PPS + PPS0 + PPS1) */
#define PPS0_RFU_MASK                   0xEF /* b2-4 and b6-8 shall be set to 0, b1 shall be set to 1. All other values are RFU! */
#define PPS0_RFU_MASK_VALUE             0x01 /* PPS0 SHALL be set to 000X 0001, all other values are RFU! */
#define PPS1_AVAILABLE_MASK             0x10 /* b5 indicates if PPS1 is transmitted if set to 1 */
#define PPS1_RFU_MASK                   0xF0 /* Higher nibble of PPS1 shall be set to 0, all other values are RFU! */
#define PPS1_RFU_MASK_VALUE             0x00 /* PPS1 SHALL be 0000 XXXX, all other values are RFU! */

#endif //_DEFINES_H_


